#include <stdio.h>
#include <string.h>

long i;
FILE* infile;
FILE* infile1;
FILE* infile2;
FILE* outfile;

FILE* settingsfile;

unsigned char datablock[115200];

long left1[19200], left2[19200], right1[19200], right2[19200];
long left_diff[19200], right_diff[19200];

char infilename1[512];
char infilename2[512];
char outfilename[512];
char indirname[512];
char outdirname[512];
char settingsfilename[512];
char appdirname[512];
char leafname[256];
char commandstring[512];

char ChunkID[5],Format[5],Subchunk1ID[5],Subchunk2ID[5];

char c1,c2,charzero;

long ChunkSize,Subchunk1Size,AudioFormat;
long NumChannels,SampleRate,ByteRate,BlockAlign;
long BitsPerSample,BytesPerSample;

long ChunkSize1,Subchunk1Size1,AudioFormat1;
long NumChannels1,SampleRate1,ByteRate1,BlockAlign1;
long BitsPerSample1,BytesPerSample1;

unsigned long Subchunk2Size,Subchunk2Size1;

long blocksize;

long i,ok,ok1,ok2,icut,icut2;

long blocksize,clip_detected;

long chunk_number, icount, chunk_size, ilength, block_size;
long pairs_per_block;

long l_int,r_int,icut,icut2,icut24,icut224;

double duration,dt,dt_ms,t_ms,duration_ms,scale;

void get4(char*);
long get4int(void);
long get2int(void);
long read_header(void);

void write_output_header(long);
void write4(char*);
void write2int(long);
void write4int(long);
long load_block1(void);
void convert_block1(void);
void convert24_block1(void);
long load_block2(void);
void convert_block2(void);
void convert24_block2(void);
long produce_diff(void);
long produce_diff24(void);
int read_settingsfile(void);
int check_inputfiles(void);
void hold_head(void);
int compare_heads(void);

void do_process(void);

int main(int argc,char*argv[])
{
  icut=32768; icut2=icut*2;
  icut24=256*icut; icut224=256*icut2;
  charzero=(char)0;
  sprintf(appdirname,"%s",argv[0]);
  i=(int)strrchr(appdirname,'/')-(int)appdirname;
  appdirname[i]=charzero;
  printf("Application Dir at = %s\n\n",appdirname);
  sprintf(settingsfilename,"%s/Settings\0",appdirname);
  printf("Settings file = %s\n",settingsfilename);
  
  printf("\n      WAVDifference 1.10 October 2010  J. C. G. Lesurf\n");
  printf("   Generates a new Wave file that contains the difference\n");
  printf("   between two input Wave files of equal duration, etc.\n");
  
  ok=read_settingsfile();

  printf("Enter name of 1st WAV file => ");
  scanf("%s",leafname);
  sprintf(infilename1,"%s/%s\0",indirname,leafname);
  printf("Full file name 1 = %s\n\n",infilename1);
 
  printf("Enter name of 2nd WAV file => ");
  scanf("%s",leafname);
  sprintf(infilename2,"%s/%s\0",indirname,leafname);
  printf("Full file name 2 = %s\n\n",infilename2);
  
  ok=check_inputfiles();
  
  if(ok==1)
  {
    printf("\nFiles OK to take difference\n");
    do_process();
    printf("\nDifference completed!\n");
  }
  else
  {
    printf("Files missing or not comparable!");
  }
  
  return 0;
}

void do_process(void)
{
    blocksize=ByteRate/10;
    printf("%ld bytes per 0.1 sec block\n",blocksize);
    
    
    printf("Enter output file name => ");
    scanf("%s",leafname);
    sprintf(outfilename,"%s/%s\0",outdirname,leafname);
    printf("Full output file name = %s\n",outfilename);
    
    pairs_per_block=blocksize/(2*BytesPerSample);
    printf("Sample (pairs)/block = %ld\n",pairs_per_block);
         
    infile1=fopen(infilename1,"rd");
    infile2=fopen(infilename2,"rd");
         
    fread(datablock,sizeof(unsigned char),44,infile1);
    fread(datablock,sizeof(unsigned char),44,infile2);
         
    outfile=fopen(outfilename,"wd");
         
    write_output_header(Subchunk2Size);
         
    chunk_number=0;
    do
    {
      printf("load 1\n");
      chunk_size=load_block1();  
      if (chunk_size>0)
      {
        pairs_per_block=chunk_size/(2*BytesPerSample);
        printf("convert 1\n");
        if(BitsPerSample==16)
        {
           convert_block1();
        }
        else
        {
          convert24_block1();
        }         
      }
               
      printf("load 2\n");
      chunk_size=load_block2();
      if (chunk_size>0)
      {
        pairs_per_block=chunk_size/(2*BytesPerSample);
        printf("convert 2\n");
        if(BitsPerSample==16)
        {
          convert_block2();
        }
        else
        {
          convert24_block2();
        }     
          
      }
             
      if(chunk_size>0)
      {
      
        if(BitsPerSample==16)
        {
          clip_detected=produce_diff();
        }
        else
        {
          clip_detected=produce_diff24();
        }
             
        if(clip_detected>0)
        {
          printf("clipping!\n");
        }
             
        chunk_number++;
        printf("%ld\n",chunk_number);
      }
              
    } while (chunk_size==blocksize);
        
    fclose(outfile);
    fclose(infile1);
    fclose(infile2);
}

int check_inputfiles(void)
{
infile=fopen(infilename1,"rd");
  if((int)infile!=0)
  {
    printf("Checking 1st input file\n");
    read_header();
    fclose(infile);
    hold_head();
    ok1=1;
  }
  else
  {
    printf("File 1 does not exist!\n\n");
    ok1=0;
  }
  infile=fopen(infilename2,"rd");
  if((int)infile!=0)
  {
    printf("Checking 2nd input file\n");
    read_header();
    fclose(infile);
    ok2=1;
  }
  else
  {
    printf("File 2 does not exist!\n\n");
    ok2=0;
  }
  
  if (ok1*ok2==1)
  {
    if(compare_heads()==0)
    {
      ok1=0; ok2=0;
      printf("Input files incompatable!\n");
    }
  }
  return ok1*ok2;
}

void hold_head(void)
{
  ChunkSize1=ChunkSize;
  AudioFormat1=AudioFormat;
  NumChannels1=NumChannels;
  ByteRate1=ByteRate;
  BitsPerSample1=BitsPerSample;
  BytesPerSample1=BytesPerSample;
  Subchunk2Size1=Subchunk2Size;
}
  

int compare_heads(void)
{
  int comp;
  comp=1;
  printf("\n\nComparing Input File Attributes\n\n");
  if(ChunkSize1!=ChunkSize)
  {
    comp=0; printf("Chunk 1 sizes differ!\n");
  }
  if(AudioFormat1!=AudioFormat)
  {
    comp=0; printf("Formats differ!\n");
  }
  if(NumChannels1!=NumChannels)
  {
    comp=0; printf("Number Channels differ!");
  }
  if(ByteRate1!=ByteRate)
  {
    comp=0; printf("Byte Rates differ!\n");
  }
  if(BitsPerSample1!=BitsPerSample)
  {
    comp=0; printf("Bits per Sample differ!\n");
  }
  if(BytesPerSample1!=BytesPerSample)
  {
    comp=0; printf("Bytes per Sample differ!\n");
  }
  if(Subchunk2Size1!=Subchunk2Size)
  {
    comp=0; printf("Payloads of different durations!\n");
  }
  
  if(NumChannels!=2)
  {
    comp=0; printf("Payloads not Stereo!\n");
  }
  
  
  return comp;
}

int read_settingsfile(void)
{
   char tempname[128];
   int rok;
   settingsfile=fopen(settingsfilename,"rt");

   if((int)settingsfile>0)
   {
     printf("\nReading settings ok\n");
     fscanf(settingsfile,"%s",indirname);    
     printf("Input directory name = %s\n",indirname);
     fscanf(settingsfile,"%s",outdirname);    
     printf("Input directory name = %s\n",outdirname);
     fclose(settingsfile);
     rok=1;
   }
   else
   {
     printf("no settings file!\n");
     rok=0;
   }
   return rok;
}


long read_header(void)
{
  long irh;

   printf("Reading header\n");
    
    get4(ChunkID);
    printf("ChunkID = %s\n",ChunkID);
    ChunkSize=get4int();
    printf("Chunk Size = %ld\n",ChunkSize);
    get4(Format);
    printf("Format = %s\n",Format);
    get4(Subchunk1ID);
    printf("Subchunk1ID = %s\n",Subchunk1ID);
    Subchunk1Size=get4int();
    AudioFormat=get2int();
    if((Subchunk1Size==16)&&(AudioFormat==1))
    {
      printf("16 bits per sample LPCM format OK\n");
    }
    else
    {
      printf("Format unknown!\n");
    }
    NumChannels=get2int();
    printf("Number of Channels = %ld\n",NumChannels);
    SampleRate=get4int();
    printf("Sample Rate = %ld\n",SampleRate);
    ByteRate=get4int();
    printf("Byte Rate = %ld\n",ByteRate);
    BlockAlign=get2int();
    printf("Block Align = %ld\n",BlockAlign);
    BitsPerSample=get2int();
    printf("Bits per sample = %ld\n",BitsPerSample);
    BytesPerSample=BitsPerSample/8;
    printf("Bytes per sample = %ld\n",BytesPerSample);
    
    get4(Subchunk2ID);
    printf("Subchunk2ID = %s\n",Subchunk2ID);
    Subchunk2Size=(unsigned long)get4int();
    printf("Subchunk2Size = %lu [Number of Data payload bytes]\n",Subchunk2Size);
    
  irh=ByteRate;
  return irh;
}



long get2int(void)
{
  long result;
  unsigned char cip1,cip2;
  
  fscanf(infile,"%c",&cip1);
  fscanf(infile,"%c",&cip2);

  result=(long)cip2;
  result=(long)cip1+256*result;

  return result;
} 

long get4int(void)
{
  long result;
  unsigned char cip1,cip2,cip3,cip4;
  
  fscanf(infile,"%c",&cip1);
  fscanf(infile,"%c",&cip2);
  fscanf(infile,"%c",&cip3);
  fscanf(infile,"%c",&cip4);
    
  result=(long)cip4;
  result=(long)cip3+256*result;
  result=(long)cip2+256*result;
  result=(long)cip1+256*result;
  
  return result;
} 
void get4(char* outstring)
{
  long isp;
  char csp;
  isp=0;
  do
  {
    fscanf(infile,"%c",&csp);
    outstring[isp]=csp;
    isp++;
  } while (isp<4);
  outstring[4]=(char)0;

}


void write4int(long inv)
{
  char cop1,cop2,cop3,cop4;
  
  cop1=(unsigned char)(inv&255);
  cop2=(unsigned char)((inv>>8)&255);
  cop3=(unsigned char)((inv>>16)&255);
  cop4=(unsigned char)((inv>>24)&255);
  
  fprintf(outfile,"%c",cop1);
  fprintf(outfile,"%c",cop2);
  fprintf(outfile,"%c",cop3);
  fprintf(outfile,"%c",cop4);
}


void write2int(long inv)
{
  unsigned char cop1,cop2;
  cop1=(unsigned char)(inv&255);
  cop2=(unsigned char)((inv>>8)&255);
  fprintf(outfile,"%c",cop1);
  fprintf(outfile,"%c",cop2);
}

void write4(char* outstring)
{
  int isp;
  
  isp=0;
  do
  {
    fprintf(outfile,"%c",outstring[isp]);
    isp++;
  } while (isp<4);
  
}


void write_output_header(long plo)
{
  
  printf("Payload to write = %ld\n\n",plo);
  write4(ChunkID);
  write4int(plo+36);
  write4(Format);
  write4(Subchunk1ID);
  write4int(Subchunk1Size);
  write2int(AudioFormat);
  write2int(NumChannels);
  write4int(SampleRate);
  write4int(ByteRate);
  write2int(BlockAlign);
  write2int(BitsPerSample);
  write4(Subchunk2ID);
  write4int(plo);
  
}


long load_block1(void)
{
  /* This procedure loads the next 0.1 second block of
     data from the input file. */
  
  long block_size_read;
  block_size_read=fread(datablock,sizeof(unsigned char),blocksize,infile1);
  return block_size_read;
}

void convert_block1(void)
{
  /* This procedure converts the values in the data block
     into integers, ready for examination. */
  
  long io,ii,lt,rt;
  ii=0; io=0;
  
  do
  {
    lt= 256*(int)datablock[ii+1] + (int)datablock[ii];
    ii+=2;
    
    rt= 256*(int)datablock[ii+1] + (int)datablock[ii];
    ii+=2;
    
    if (lt>=icut) lt-=icut2;
    if (rt>=icut) rt-=icut2;
    left1[io]=lt;
    right1[io]=rt;
    io++;
  } while (io<pairs_per_block);
}


long load_block2(void)
{
  /* This procedure loads the next 0.1 second block of
     data from the input file. */
  
  long block_size_read;
  block_size_read=fread(datablock,sizeof(char),blocksize,infile2);
  return block_size_read;
}

void convert_block2(void)
{
  /* This procedure converts the values in the data block
     into integers, ready for examination. */
  
  long io,ii,lt,rt;
  ii=0; io=0;
  
  do
  {
    lt= 256*(int)datablock[ii+1] + (int)datablock[ii];
    ii+=2;
    
    rt= 256*(int)datablock[ii+1] + (int)datablock[ii];
    ii+=2;
    
    if (lt>=icut) lt-=icut2;
    if (rt>=icut) rt-=icut2;
    left2[io]=lt;
    right2[io]=rt;
    io++;
  } while (io<pairs_per_block);
}

long produce_diff(void)
{
  long io,ii,lt,rt;
  long clip_check;
  unsigned char l1,l2,r1,r2;
  ii=0; io=0; clip_check=0;
  
  do
  {
    left_diff[io]=left2[io]-left1[io];
    right_diff[io]=right2[io]-right1[io];
    
    lt=(long)left_diff[io];
    rt=(long)right_diff[io];
    
    if(lt>32767)
    {
      lt=32767;
      clip_check=1;
    }
    
    if(lt<-32767)
    {
      lt=-32767;
      clip_check=1;
    }
    
    if(rt>32767)
    {
      rt=32767;
      clip_check=1;
    }
    
    if(rt<-32767)
    {
      rt=-32767;
      clip_check=1;
    }
    
  
    if(lt<0) lt+=2*icut;
    if(rt<0) rt+=2*icut;
    
    l1=(unsigned char)((lt>>8)&255);
    l2=(unsigned char)(lt&255);
    r1=(unsigned char)((rt>>8)&255);
    r2=(unsigned char)(rt&255);
    
    datablock[ii]=l2;
    datablock[ii+1]=l1;
    datablock[ii+2]=r2;
    datablock[ii+3]=r1;
    
    io++; ii+=4;
    
  }while (io<pairs_per_block);
  
  fwrite(datablock,sizeof(unsigned char),chunk_size,outfile);
  return clip_check;
}

void convert24_block1(void)
{
  /* This procedure converts the values in the data block
     into integers, ready for examination. */
  
  long io,ii,lt,rt;
  ii=0; io=0;
  
  do
  {
    lt= 65536*(int)datablock[ii+2] + 256*(int)datablock[ii+1] + (int)datablock[ii];
    ii+=3;
    
    rt= 65536*(int)datablock[ii+2] + 256*(int)datablock[ii+1] + (int)datablock[ii];
    ii+=3;
    
    if (lt>=icut24) lt-=icut224;
    if (rt>=icut24) rt-=icut224;
    left1[io]=lt;
    right1[io]=rt;
    io++;
  } while (io<pairs_per_block);
}



void convert24_block2(void)
{
  /* This procedure converts the values in the data block
     into integers, ready for examination. */
  
  long io,ii,lt,rt;
  ii=0; io=0;
  
  do
  {
    lt= 65536*(int)datablock[ii+2] + 256*(int)datablock[ii+1] + (int)datablock[ii];
    ii+=3;
    
    rt= 65536*(int)datablock[ii+2] + 256*(int)datablock[ii+1] + (int)datablock[ii];
    ii+=3;
    
    if (lt>=icut24) lt-=icut224;
    if (rt>=icut24) rt-=icut224;
    left2[io]=lt;
    right2[io]=rt;
    io++;
  } while (io<pairs_per_block);
}

long produce_diff24(void)
{
  long io,ii,lt,rt;
  long clip_check;
  unsigned char l1,l2,r1,r2,l3,r3;
  ii=0; io=0; clip_check=0;
  
  do
  {
    left_diff[io]=left2[io]-left1[io];
    right_diff[io]=right2[io]-right1[io];
    
    lt=(long)left_diff[io];
    rt=(long)right_diff[io];
    
    if(lt>8388607)
    {
      lt=8388607;
      clip_check=1;
    }
    
    if(lt<-8388607)
    {
      lt=-8388607;
      clip_check=1;
    }
    
    if(rt>8388607)
    {
      rt=8388607;
      clip_check=1;
    }
    
    if(rt<-8388607)
    {
      rt=-8388607;
      clip_check=1;
    }
    
  
    if(lt<0) lt+=2*icut24;
    if(rt<0) rt+=2*icut24;
    
    l1=(unsigned char)((lt>>16)&255);    
    l2=(unsigned char)((lt>>8)&255);
    l3=(unsigned char)(lt&255);
    
    
    r1=(unsigned char)((rt>>16)&255);
    r2=(unsigned char)((rt>>8)&255);
    r3=(unsigned char)(rt&255);
    
    datablock[ii]=l3;
    datablock[ii+1]=l2;
    datablock[ii+2]=l1;
    
    datablock[ii+3]=r3;
    datablock[ii+4]=r2;
    datablock[ii+5]=r1;
    
    io++; ii+=6;
    
  }while (io<pairs_per_block);
  
  fwrite(datablock,sizeof(unsigned char),chunk_size,outfile);
  return clip_check;
}



